;  "Critter"
;  By Brett Bilbrey, 1980
;  For Bally Arcade/Astrocade
;  Modded by Andy Guevara in 1982 for use with "Machine Language
;  Manager" cartridge 
;
;  This version of "Critter" is from the "Machine Language Manager"
;  manual, page 7-2.  It, in turn, is a modified version of the
;  "CRITTER" program from the Oct. 80 issue of the Cursor newsletter.
;
;  Turn KN(1) to change the speed of the "critter."
;
;  Note: This will NOT run as a cartridge-- it's meant
;        to be run un MLM. 
;
;  Version History:
;    .06 (July 29, 2013)
;       - Updated to match byte-for-byte with version in "Machine
;         Language Manager"manual.
;       - Removed HVGLIB.H and replaced with equates to more closely
;         resemble the original source code.
;    .05 (December 7, 2011)
;       - Fixed the comments on the Critter's Pattern 
;    .04 (June 5, 2004)
;       - Noted that this will only run under MLM
;    .03 (December 6, 2003)
;       - Updated so it works with HVGLIB.H
;    .02 (January 28, 2002)
;       - Slight Modifications
;    .01 (November 11, 2001)
;       - Re-typed by Adam Trionfo
;
;  To assemble this Z-80 source code using ZMAC:
;  
;     zmac -d -o <outfile> -x <listfile> <filename>
;  
;  For example, assemble this Astrocade Z-80 ROM file:
;     
;     zmac -i -m -o critter.bin -x critter.lst critter.z80 
;

SCINT   EQU     $4FB2           ; Screen interrupt vector
CLEAR   EQU     $2347           ; "MLM" "Clear Screen" Routine
POT0    EQU     $1C             ; read POTentiometer 0 for player 1 knob
SYSTEM  EQU     $FF             ; System CALLs
INTPC   EQU     $00             ; INTerPret with Context create
MCALL   EQU     $06             ; Macro CALL interpreter subroutine
XINTC   EQU     $02             ; eXit INTerpreter with Context
VECT    EQU     $3E             ; VEctor ObjeCT in two dimensions
VWRITR  EQU     $1E             ; Vector WRITe Relative 

        ORG     $4E40           ; First byte of Cartridge

L4E40:  DI
        PUSH    HL
        LD      HL,L4E4F        ; Load screen interrupt vector
        LD      (SCINT),HL      ; with address of routine
        CALL    CLEAR
        POP     HL
        EI
        RET

        NOP

L4E4F:  PUSH    AF              ; First Byte of Interrupt Routine
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IX
        PUSH    IY
        IN      A,(POT0)        ; Get KNOB(1) value
        LD      (TIMBAS),A       ; Put in Vector Block (Time Base)

        DB      SYSTEM          ; System CALL (On-Board ROM)              
        DB      INTPC           ;   Start Interpreter
        DB      MCALL+1         ;      Macro CALL interpreter subroutine
        DW      VWRITE          ;         Jump to Vector Write             
        DB      VECT+1          ;      Move Vector
        DW      VECBLK          ;         Vector Address
        DW      LMTABL          ;         Limit Table                           
        DB      MCALL+1         ;      Macro CALL interpreter subroutine
        DW      VWRITE          ;         Jump to Vector Write
        DB      XINTC           ;   eXit INTerpreter with Context

        POP     IY              ; Clean up and go home
        POP     IX
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        EI
        RET

        NOP
        
VWRITE: DB      VWRITR+1        ; Vector WRITe from Relative
        DW      VECBLK          ; Address of Vector block
        DW      PATERN          ; Pattern
        DB      $08             ; Returns for subroutines

        NOP

;  Limit table
LMTABL: DB      $00,$98         ; X Boundaries
        DB      $00,$50         ; Y boundaries

;  Critter Pattern
PATERN: DB     0,0              ; Pattern 0,0 position
        DB     2,8              ; 2 bytes wide, 8 lines long pattern size
        DB     $0A,$A0          ; . . 2 2 2 2 . .  
        DB     $22,$88          ; . 2 . 2 2 . 2 .
        DB     $AA,$AA          ; 2 2 2 2 2 2 2 2
        DB     $2A,$A8          ; 2 2 2 2 2 2 .
        DB     $08,$20          ; . . 2 . . 2 . .
        DB     $20,$08          ; . 2 . . . . 2 .
        DB     $08,$20          ; . . 2 . . 2 . .
        DB     $00,$00          ; . . . . . . . .

        NOP

;  VECTOR BLOCK
VECBLK: DB     $20        ; Magic Register value
        DB     $80        ; Vector Status
TIMBAS: DB     $00        ; Time Base - Holds KN(1) value
        DW     $0005      ; Delta X
        DW     $0000      ; X Position
        DB     $03        ; X Checks Mask
        DW     $0005      ; Delta Y
        DW     $0000      ; Y Position
L4EA1:  DB     $03        ; Checks Mask

END                       ; End of Program